/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.widget.sidebutton;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.integration.jei.JeiIntegration;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;

public abstract class SearchBoxModeSideButton
extends SideButton {
    private static final List<Integer> MODE_ROTATION = Arrays.asList(0, 1, 2, 3, 4, 5, 0);

    protected SearchBoxModeSideButton(BaseScreen<?> screen) {
        super(screen);
    }

    private static int nextMode(int oldMode) {
        return MODE_ROTATION.get(MODE_ROTATION.indexOf(oldMode) + 1);
    }

    @Override
    protected String getTooltip() {
        return I18n.m_118938_((String)"sidebutton.refinedstorage.grid.search_box_mode", (Object[])new Object[0]) + "\n" + ChatFormatting.GRAY + I18n.m_118938_((String)("sidebutton.refinedstorage.grid.search_box_mode." + this.getSearchBoxMode()), (Object[])new Object[0]);
    }

    @Override
    protected void renderButtonIcon(PoseStack poseStack, int x, int y) {
        int mode = this.getSearchBoxMode();
        this.screen.m_93228_(poseStack, x, y, IGrid.isSearchBoxModeWithAutoselection(mode) ? 16 : 0, 96, 16, 16);
    }

    public void m_5691_() {
        int mode = SearchBoxModeSideButton.nextMode(this.getSearchBoxMode());
        if (IGrid.doesSearchBoxModeUseJEI(mode) && !JeiIntegration.isLoaded()) {
            mode = 0;
        }
        this.setSearchBoxMode(mode);
    }

    protected abstract int getSearchBoxMode();

    protected abstract void setSearchBoxMode(int var1);
}

